#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
using namespace std;

int main() {
    int n;
    cin >> n;
    cin.ignore(); // skip newline

    string s;
    getline(cin, s);

    // make sure string has length n
    if (s.size() > n) s = s.substr(0, n);
    else if (s.size() < n) {
        cerr << "Error: string too short!" << endl;
        return 1;
    }

    char chPlus = '+';
    char chHash = '#';

    size_t posPlus = s.find(chPlus);
    if (posPlus == string::npos) {
        cerr << "Error: '+' not found!" << endl;
        return 1;
    }

    vector<int> hashPos;
    size_t pos = s.find(chHash);
    while (pos != string::npos) {
        hashPos.push_back(static_cast<int>(pos));
        pos = s.find(chHash, pos + 1);
    }

    int minimal = n + 1;
    int plusPos = static_cast<int>(posPlus);

    for (int p : hashPos) {
        int x = abs(p - plusPos);
        int y = n - x;
        minimal = min(minimal, min(x, y));
    }

    cout << minimal << endl;
    return 0;
}